<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
<link rel="stylesheet" href="<?= base_url('/css/production.css') . '?' . rand() ?>" />
<script type="text/javascript" src="<?php echo base_url('js/jquery/jquery-3.7.1.min.js'); ?>"></script>
<script type="text/javascript" src="<?php echo base_url('js/jquery-ui-1.14.1/jquery-ui.min.js'); ?>"></script>
<script type='text/javascript' src="<?= base_url('/js/html-duration-picker.min.js') ?>"></script>
<script type='text/javascript' src="<?= base_url('js/htmx/htmx.min.js') ?>"></script>
<script type='text/javascript' src="<?=base_url('/js/daypilot-modal-confirm/js/daypilot-modal-3.15.1.min.js');?>"></script>
<link rel="stylesheet" href="<?=base_url('/js/daypilot-modal-confirm/themes/modal_rounded.css'); ?>" type="text/css">

<style>
    .scroll-btn {
        min-width: 0;
        background-color: unset;
        color: unset;
        border-radius: unset;
    }
</style>
<main>
    <div id="res"></div>
    <div class="outer">
        <div style="grid-column: 1;  grid-row: 1; ">
            <div style="display: grid; grid-template-columns: 80% 20%; padding: 0; margin:0; ">
                <p class="s1" style="padding-top: 11pt;padding-left: 10pt;text-indent: 0pt;text-align: left;">COFFEE QUALITY CONTROL CHECKLIST</p>
                <div>
                    <a class="/*button*/" href="<?= url_to('Production::index') ?>"><img style="width: 15vw;" src="<?= base_url('/images/RoastPRO-02.jpg') ?>" alt=""></a>
                </div>
            </div>
            <div class="coffee-quality-control-checklist">
                <div style="grid-column:1 /SPAN 2;">
                    <p class="s2" style="padding-top: 2pt;padding-left: 5pt;text-indent: 0pt;text-align: left;">Coffee Name:
                        <select name="coffee_name" id="coffee_name" required onchange="getGreenCoffees('coffee_name')">
                            <?php foreach ($recipes as $recipe): ?>
                                <option value="<?= $recipe->RecipeName ?>"
                                    <?= $recipe->RecipeName == $production->coffee_name ? 'selected' : '';  ?>>
                                    <?= $recipe->RecipeName ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </p>
                    <p class="s2" style="padding-top: 2pt;padding-left: 5pt;text-indent: 0pt;text-align: left;">Batch Number: <input class="grid-cell" type="text" name="batch_number" id="batch_number" value="<?= old("batch_number", esc($production->batch_number)) ?>" required></p>

                    <!-- certifications -->

                    <div id="certifications" style="padding:0; display:grid; gap:0; grid-template-columns:repeat(6,1fr);">
                        <div style="grid-column: 1 / SPAN 2; grid-row: 2;">
                            <p class="s4" style="padding-top: 3pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Certification:</p>
                        </div>
                        <div style="grid-column:3; grid-row:2;">
                            <p class="s3 grid-cell-center">N/A</p>
                            <input class="grid-cell" type="checkbox" name="certification_na[]" id="certification_na" value="1" <?= $production->certification_na ? 'checked' : '' ?>>
                        </div>
                        <div style="grid-column:4; grid-row:2;">
                            <p class="s3 grid-cell-center">Fairtrade</p>
                            <input class="grid-cell" type="checkbox" name="certification_fairtrade[]" id="certification_fairtrade" value="1" <?= $production->certification_fairtrade ? 'checked' : '' ?>>
                        </div>
                        <div style="grid-column:5; grid-row:2;">
                            <p class="s3 grid-cell-center">RFA</p>
                            <input class="grid-cell" type="checkbox" name="certification_rfa[]" id="certification_rfa" value="1" <?= $production->certification_rfa ? 'checked' : '' ?>>
                        </div>
                        <div style="grid-column:6; grid-row:2;">
                            <p class="s3 grid-cell-center">Organic</p>
                            <input class="grid-cell" type="checkbox" name="certification_organic[]" id="certification_organic" value="1" <?= $production->certification_organic ? 'checked' : '' ?>>
                        </div>
                    </div>
                </div>
                <div style="grid-column:3;">
                    <div style="display:grid; grid-template-columns:repeat(2,128px);">
                        <div class="s2" style="grid-column: 1; grid-row:1; padding: 0 20px;">
                            Date:
                        </div>
                        <div style="grid-column:2; grid-row:1;">
                            <input class="s2 grid-cell" type="date" name="check_date" id="check_date" value="<?= old("check_date", date_format(date_create($production->check_date), 'Y-m-d')) ?>" required>
                        </div>

                        <div class="s2" style="grid-column: 1; grid-row:2; padding: 0 20px;">
                            Checked by:
                        </div>
                        <div style="grid-column:2; grid-row:2;">
                            <input class="s2 grid-cell" type="text" name="checked_by" id="checked_by" value="<?= old("checked_by", esc($production->checked_by)) ?>" required>
                        </div>

                        <div class="s2" style="grid-column: 1; grid-row:3; padding: 0 20px;">
                            Qty Requested:
                        </div>
                        <div style="grid-column:2; grid-row:3;">
                            <input class="s2 grid-cell" type="number" name="qty_requested" id="qty_requested" step="0.01" placeholder="0.00" value="<?= old("qty_requested", esc($production->qty_requested)) ?>" required>
                        </div>

                        <div class="s2" style="grid-column: 1; grid-row:4; padding: 0 20px;">
                            Qty Produced:
                        </div>
                        <div style="grid-column:2; grid-row:4;">
                            <input class="s2 grid-cell" type="number" name="qty_produced" id="qty_produced" step="0.01" placeholder="0.00" value="<?= old("qty_produced", esc($production->qty_produced)) ?>">
                        </div>
                    </div>
                </div>
            </div>

            <p class="s4" style="padding-top: 4pt;padding-left: 29pt;text-indent: -17pt;text-align: left;">1. Green Coffee Inspection (Before Roasting)</p>
            <div class="green-coffee-inspection">
                <div style="grid-column:1; grid-row:1;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Green Coffee</p>
                </div>
                <div style="grid-column:2; grid-row:1;">
                    <p class="s3" style="padding-top: 5pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Qty Used</p>
                </div>
                <div style="grid-column:3; grid-row:1;">
                    <p class="s3" style="padding-left: 11pt;text-indent: 0pt;text-align: left;">Moisture Level</p>
                    <p style="padding-left: 11pt;text-indent: 0pt;text-align: left;">(Target: 10-12%)</p>
                </div>

                <div id="cert-header" style="grid-column:4; grid-row:1;">
                    <div class="v-small" style="display:grid; grid-template-columns:repeat(4,auto);">
                        <div style="writing-mode:vertical-lr;">RFA</div>
                        <div style="writing-mode:vertical-lr;">Organic</div>
                        <div style="writing-mode:vertical-lr;">Fairtrade</div>
                        <div style="writing-mode:vertical-lr;">N/A</div>
                    </div>
                </div>


                <div style="grid-column:5; grid-row:1;">

                    <p class="s3" style="text-align: center;">Visual Check</p>
                    <p class="v-small" style="text-align: center;">(Defects, Inconsistencies, Foreign Matter)</p>
                    <div class="v-small grid-cell-center " style="display: grid; grid-template-columns:repeat(2,auto); gap:0;">
                        <div>Pass</div>
                        <div>Fail</div>
                    </div>
                </div>
                <div style="grid-column:6; grid-row:1;">
                    <p class="s3" style="text-align: center;">Smell Check</p>
                    <p class="v-small" style="text-align: center;">(Fresh, No Off-Odors)</p>
                    <div class="v-small grid-cell-center " style="display: grid; grid-template-columns:repeat(2,auto); gap:0;">
                        <div>Pass</div>
                        <div>Fail</div>
                    </div>
                </div>

                <div style="grid-column:1; grid-row:2;">
                    <select class="s3 grid-cell" name="green_coffee1" id="green_coffee1" required>
                        <?php foreach ($coffees as $coffee): ?>
                            <option value="<?= $coffee->InputName ?>"
                                <?= $coffee->InputName == $production->green_coffee1 ? 'selected' : '';  ?>>
                                <?= $coffee->InputName ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div style="grid-column:1; grid-row:3;">
                    <select class="s3 grid-cell" name="green_coffee2" id="green_coffee2">
                        <?php foreach ($coffees as $coffee): ?>
                            <option value="<?= $coffee->InputName ?>"
                                <?= $coffee->InputName == $production->green_coffee2 ? 'selected' : '';  ?>>
                                <?= $coffee->InputName ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div style="grid-column:1; grid-row:4;">
                    <select class="s3 grid-cell" name="green_coffee3" id="green_coffee3">
                        <?php foreach ($coffees as $coffee): ?>
                            <option value="<?= $coffee->InputName ?>"
                                <?= $coffee->InputName == $production->green_coffee3 ? 'selected' : '';  ?>>
                                <?= $coffee->InputName ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div style="grid-column:1; grid-row:5;">
                    <select class="s3 grid-cell" name="green_coffee4" id="green_coffee4">
                        <?php foreach ($coffees as $coffee): ?>
                            <option value="<?= $coffee->InputName ?>"
                                <?= $coffee->InputName == $production->green_coffee4 ? 'selected' : '';  ?>>
                                <?= $coffee->InputName ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div style="grid-column:1; grid-row:6;">
                    <select class="s3 grid-cell" name="green_coffee5" id="green_coffee5">
                        <?php foreach ($coffees as $coffee): ?>
                            <option value="<?= $coffee->InputName ?>"
                                <?= $coffee->InputName == $production->green_coffee5 ? 'selected' : '';  ?>>
                                <?= $coffee->InputName ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div style="grid-column:2; grid-row:2;">
                    <input class="grid-cell s3" type="number" name="qty_used1" id="qty_used1" value="<?= old("qty_used1", esc($production->qty_used1)) ?>">
                </div>
                <div style="grid-column:2; grid-row:3;">
                    <input class="grid-cell s3" type="number" name="qty_used2" id="qty_used2" value="<?= old("qty_used2", esc($production->qty_used2)) ?>">
                </div>
                <div style="grid-column:2; grid-row:4;">
                    <input class="grid-cell s3" type="number" name="qty_used3" id="qty_used3" value="<?= old("qty_used3", esc($production->qty_used3)) ?>">
                </div>
                <div style="grid-column:2; grid-row:5;">
                    <input class="grid-cell s3" type="number" name="qty_used4" id="qty_used4" value="<?= old("qty_used4", esc($production->qty_used4)) ?>">
                </div>
                <div style="grid-column:2; grid-row:6;">
                    <input class="grid-cell s3" type="number" name="qty_used5" id="qty_used5" value="<?= old("qty_used5", esc($production->qty_used5)) ?>">
                </div>

                <div style="grid-column:3; grid-row:2;">
                    <input class="grid-cell s3" type="number" name="moisture_level1" id="moisture_level1" value="<?= old("moisture_level1", esc($production->moisture_level1)) ?>">
                </div>
                <div style="grid-column:3; grid-row:3;">
                    <input class="grid-cell s3" type="number" name="moisture_level2" id="moisture_level2" value="<?= old("moisture_level2", esc($production->moisture_level2)) ?>">
                </div>
                <div style="grid-column:3; grid-row:4;">
                    <input class="grid-cell s3" type="number" name="moisture_level3" id="moisture_level3" value="<?= old("moisture_level3", esc($production->moisture_level3)) ?>">
                </div>
                <div style="grid-column:3; grid-row:5;">
                    <input class="grid-cell s3" type="number" name="moisture_level4" id="moisture_level4" value="<?= old("moisture_level4", esc($production->moisture_level4)) ?>">
                </div>
                <div style="grid-column:3; grid-row:6;">
                    <input class="grid-cell s3" type="number" name="moisture_level5" id="moisture_level5" value="<?= old("moisture_level5", esc($production->moisture_level5)) ?>">
                </div>
                <!-- <div id="cert-coffees" style="padding: 0; margin: 0; grid-column:4; grid-row:2 / SPAN 6; display: grid; grid-template-columns: repeat(1, auto); gap: 0; padding: 0; margin: 0;"> -->
                <div style="grid-column:4; grid-row:2;">
                    <div id="cert-row2" style="padding:0; display:grid; gap:0; grid-template-columns:repeat(4,auto);align-content:center;">
                        <div style="grid-column:1;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="rfa1[]" id="rfa1" value="1" <?= $production->rfa1 ? 'checked' : '' ?>></div>
                        <div style="grid-column:2;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="organic1[]" id="organic1" value="1" <?= $production->organic1 ? 'checked' : '' ?>></div>
                        <div style="grid-column:3;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="fairtrade1[]" id="fairtrade1" value="1" <?= $production->fairtrade1 ? 'checked' : '' ?>></div>
                        <div style="grid-column:4;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="na1[]" id="na1" value="1" <?= $production->na1 ? 'checked' : '' ?>></div>
                    </div>
                </div>

                <div style="grid-column:4; grid-row:3;">
                    <div id="cert-row3" style="padding:0; display:grid; gap:0; grid-template-columns:repeat(4,auto);align-content:center;">
                        <div style="grid-column:1;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="rfa2[]" id="rfa2" value="1" <?= $production->rfa2 ? 'checked' : '' ?>></div>
                        <div style="grid-column:2;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="organic2[]" id="organic2" value="1" <?= $production->organic2 ? 'checked' : '' ?>></div>
                        <div style="grid-column:3;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="fairtrade2[]" id="fairtrade2" value="1" <?= $production->fairtrade2 ? 'checked' : '' ?>></div>
                        <div style="grid-column:4;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="na2[]" id="na2" value="1" <?= $production->na2 ? 'checked' : '' ?>></div>
                    </div>
                </div>

                <div style="grid-column:4; grid-row:4;">
                    <div id="cert-row4" style="padding:0; display:grid; gap:0; grid-template-columns:repeat(4,auto);align-content:center;">
                        <div style="grid-column:1;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="rfa3[]" id="rfa3" value="1" <?= $production->rfa3 ? 'checked' : '' ?>></div>
                        <div style="grid-column:2;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="organic3[]" id="organic3" value="1" <?= $production->organic3 ? 'checked' : '' ?>></div>
                        <div style="grid-column:3;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="fairtrade3[]" id="fairtrade3" value="1" <?= $production->fairtrade3 ? 'checked' : '' ?>></div>
                        <div style="grid-column:4;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="na3[]" id="na3" value="1" <?= $production->na3 ? 'checked' : '' ?>></div>
                    </div>
                </div>

                <div style="grid-column:4; grid-row:5;">
                    <div id="cert-row5" style="padding:0; display:grid; gap:0; grid-template-columns:repeat(4,auto);align-content:center;">
                        <div style="grid-column:1;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="rfa4[]" id="rfa4" value="1" <?= $production->rfa4 ? 'checked' : '' ?>></div>
                        <div style="grid-column:2;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="organic4[]" id="organic4" value="1" <?= $production->organic4 ? 'checked' : '' ?>></div>
                        <div style="grid-column:3;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="fairtrade4[]" id="fairtrade4" value="1" <?= $production->fairtrade4 ? 'checked' : '' ?>></div>
                        <div style="grid-column:4;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="na4[]" id="na4" value="1" <?= $production->na4 ? 'checked' : '' ?>></div>
                    </div>
                </div>

                <div style="grid-column:4; grid-row:6;">
                    <div id="cert-row6" style="padding:0; display:grid; gap:0; grid-template-columns:repeat(4,auto);align-content:center;">
                        <div style="grid-column:1;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="rfa5[]" id="rfa5" value="1" <?= $production->rfa5 ? 'checked' : '' ?>></div>
                        <div style="grid-column:2;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="organic5[]" id="organic5" value="1" <?= $production->organic5 ? 'checked' : '' ?>></div>
                        <div style="grid-column:3;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="fairtrade5[]" id="fairtrade5" value="1" <?= $production->fairtrade5 ? 'checked' : '' ?>></div>
                        <div style="grid-column:4;grid-row:1;" class="grid-cell-checkbox"><input type="checkbox" name="na5[]" id="na5" value="1" <?= $production->na5 ? 'checked' : '' ?>></div>
                    </div>
                </div>
                <!-- </div> -->

                <div style="grid-column:5; grid-row:2;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,auto);">
                        <input class="grid-cell-checkbox" type="radio" name="visual_check1" id="visual-check-pass1" <?= $production->visual_check1 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('visual_check1', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="visual_check1" id="visual-check-fail1" <?= $production->visual_check1 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('visual_check1', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:5; grid-row:3;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="visual_check2" id="visual-check-pass2" <?= $production->visual_check2 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('visual_check2', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="visual_check2" id="visual-check-fail2" <?= $production->visual_check2 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('visual_check2', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:5; grid-row:4;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="visual_check3" id="visual-check-pass3" <?= $production->visual_check3 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('visual_check3', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="visual_check3" id="visual-check-fail3" <?= $production->visual_check3 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('visual_check3', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:5; grid-row:5;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="visual_check4" id="visual-check-pass4" <?= $production->visual_check4 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('visual_check4', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="visual_check4" id="visual-check-fail4" <?= $production->visual_check4 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('visual_check4', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:5; grid-row:6;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="visual_check5" id="visual-check-pass5" <?= $production->visual_check5 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('visual_check5', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="visual_check5" id="visual-check-fail5" <?= $production->visual_check5 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('visual_check5', 0) ?>>
                    </div>
                </div>

                <div style="grid-column:6; grid-row:2;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="smell_check1" id="smell-check-pass1" <?= $production->smell_check1 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('smell_check1', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="smell_check1" id="smell-check-fail1" <?= $production->smell_check1 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('smell_check1', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:6; grid-row:3;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="smell_check2" id="smell-check-pass2" <?= $production->smell_check2 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('smell_check2', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="smell_check2" id="smell-check-fail2" <?= $production->smell_check2 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('smell_check2', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:6; grid-row:4;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="smell_check3" id="smell-check-pass3" <?= $production->smell_check3 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('smell_check3', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="smell_check3" id="smell-check-fail3" <?= $production->smell_check3 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('smell_check3', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:6; grid-row:5;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="smell_check4" id="smell-check-pass4" <?= $production->smell_check4 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('smell_check4', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="smell_check4" id="smell-check-fail4" <?= $production->smell_check4 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('smell_check4', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:6; grid-row:6;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="smell_check5" id="smell-check-pass5" <?= $production->smell_check5 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('smell_check5', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="smell_check5" id="smell-check-fail5" <?= $production->smell_check5 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('smell_check5', 0) ?>>
                    </div>
                </div>

                <div class="s3" style="grid-column:1;grid-row:7;">Comments:</div>
                <div style="grid-column: 2 / SPAN 6; grid-row:7;"><input class="grid-cell s3" type="text" name="green_coffee_comments" id="green_coffee_comments" value="<?= old("green_coffee_comments", esc($production->green_coffee_comments)) ?>"></div>

            </div>

            <div class="roasting">
                <div style="grid-column:1;">
                    <p class="s4" style="padding-top: 4pt;padding-left: 33pt;text-indent: -22pt;text-align: left;">2. Roasting Process Checks</p>
                    <div class="roasting-process-checks">
                        <div class="s3 grid-cell-center" style="grid-column:1; grid-row:1;margin-top:12px;">
                            Diedrich CR35 <input class="grid-cell-checkbox" type="checkbox" name="diedrich_cr35[]" id="diedrich_cr35" value="1" <?= $production->diedrich_cr35 ? 'checked' : '' ?>>
                        </div>
                        <div class="s3 grid-cell-center" style="grid-column:2; grid-row:1;margin-top:12px;">
                            Joper 120 <input class="grid-cell-checkbox" type="checkbox" name="joper_120[]" id="joper_120" value="1" <?= $production->joper_120 ? 'checked' : '' ?>>
                        </div>
                        <div class="s3" style="grid-column:3; grid-row:1;">
                            Profile Used <br /> <input class="grid-cell" type="text" name="profile_used" id="profile_used" value="<?= old("profile_used", esc($production->profile_used)) ?>">
                        </div>
                        <div class="s3" style="grid-column:1; grid-row:2;">
                            End Temp Target:<br />
                            <p class="v-small">oC</p><input class="grid-cell" type="number" name="end_temp_target" id="end_temp_target" step="0.01" placeholder="0.00" value="<?= old("end_temp_target", $production->end_temp_target) ?>">
                        </div>
                        <div class="s3" style="grid-column:2; grid-row:2;">
                            Actual:<br />
                            <p class="v-small">oC</p><input class="grid-cell" type="number" name="actual_temp" id="actual_temp" step="0.01" placeholder="0.00" value="<?= old("actual_temp", $production->actual_temp) ?>">
                        </div>
                        <div class="s3" style="grid-column:3; grid-row:2;">
                            First Crack Timing<br />
                            <p class="v-small">(hh:mm:ss):</p><input class="grid-cell html-duration-picker" name="first_crack_timing" id="first_crack_timing" value="<?= old("first_crack_timing", $production->first_crack_timing) ?>">
                        </div>
                        <div class="s3 grid-cell-flex-center" style="grid-column:1 / SPAN 2; grid-row:3;">
                            Colour Analysis (Agtron Number)
                        </div>
                        <div class="s3" style="grid-column:3; grid-row:3;" class="grid-cell">
                            <input class="grid-cell" type="number" name="colour_analysis" id="colour_analysis" step="0.01" placeholder="0.00" value="<?= old("colour_analysis", $production->colour_analysis) ?>">
                        </div>
                    </div>
                </div>
                <div style="grid-column:2;">
                    <p class="s4" style="padding-top: 4pt;padding-left: 40pt;text-indent: -22pt;text-align: left;">3. Post-Roast Quality Checks</p>
                    <div class="post-roast-quality-check">
                        <div style="grid-column: 1; grid-row:1;">
                            <div style="display: grid; grid-template-columns: 80% 20%;">
                                <div style="grid-column:2; grid-row:1;">
                                    <div style="display: grid; grid-template-columns:repeat(2,auto);">
                                        <div class="v-small grid-cell-checkbox">Pass</div>
                                        <div class="v-small grid-cell-checkbox">Fail</div>
                                    </div>
                                </div>

                                <div class="s3" style="grid-column:1; grid-row:2;">
                                    Bean Appearance <span class="s8">(Even Roast, No Scorching, No Tipping)</span>
                                </div>
                                <div style="grid-column:2; grid-row:2;">
                                    <div style="display: grid; grid-template-columns:repeat(2,auto);">
                                        <input class="grid-cell-checkbox" type="radio" name="bean_apperance" id="bean_apperance-pass" <?= $production->bean_apperance == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('bean_apperance', 1) ?>>
                                        <input class="grid-cell-checkbox" type="radio" name="bean_apperance" id="bean_apperance-fail" <?= $production->bean_apperance == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('bean_apperance', 0) ?>>
                                    </div>
                                </div>

                                <div class="s3" style="grid-column:1; grid-row:3;">
                                    Moisture Level After Roasting (%):
                                </div>
                                <div class="s3" style="grid-column:2; grid-row:3;">
                                    <input class="grid-cell" type="number" name="moisture_level_after_roasting" id="moisture_level_after_roasting" step="0.01" placeholder="0.00" value="<?= old("moisture_level_after_roasting", $production->moisture_level_after_roasting) ?>">
                                </div>
                            </div>
                            <div class="s3" style="grid-column:1 / SPAN 2; grid-row:4;">
                                Comments:
                            </div>
                            <div class="s3" style="grid-column:1 / SPAN 2; grid-row:5;">
                                <textarea class="grid-cell" name="post_roast_comments" id="post_roast_comments" rows="3" value="<?= old("post_roast_comments", esc($production->post_roast_comments)) ?>"></textarea>
                            </div>
                        </div>

                    </div>
                </div>
            </div>


            <p class="s4" style="padding-left: 34pt;text-indent: -23pt;text-align: left;">4. Cupping &amp; Sensory Analysis</p>
            <!-- 7 columns -->
            <div class="cupping">
                <div style="grid-column: 2; grid-row: 1;">
                    <p class="v-small">Yes
                        No
                    </p>
                </div>
                <div class="s3 grid-cell" style="grid-column: 1 / SPAN 3; grid-row:2;">
                    Cupping Conducted?
                    <input type="radio" name="cupping_conducted" id="cupping_conducted-yes" <?= $production->cupping_conducted == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('cupping_conducted', 1) ?>>
                    <input type="radio" name="cupping_conducted" id="cupping_conducted-no" <?= $production->cupping_conducted == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('cupping_conducted', 0) ?>>
                </div>
                <div class="s3" style="grid-column: 4 / SPAN 7; grid-row:2;">
                    Cupped by: <input class="grid-cell" type="text" name="cupped_by" id="cupped_by" value="<?= old("cupped_by", esc($production->cupped_by)) ?>">
                </div>

                <div style="grid-column:1; grid-row:3;padding:0 2px;">
                    <p class="s3" style="padding-top: 4pt; text-indent: 0pt;text-align: left;">Fragrance/Aroma</p>
                    <div class="v-small range-val" id="fragranceVal">
                        <?= old("fragrance", $production->fragrance) ?>
                    </div>
                    <input type="range" min="6" max="10" name="fragrance" id="fragrance" list="range-6-10" step="0.25" value="<?= old("fragrance", $production->fragrance) ?>" onchange="showRangeValue('fragrance', 'fragranceVal');">
                    <datalist id="range-6-10" class="range-6-10">
                        <option value="6">6</option>
                        <option value="6.25"></option>
                        <option value="6.5"></option>
                        <option value="6.75"></option>
                        <option value="7">7</option>
                        <option value="7.25"></option>
                        <option value="7.5"></option>
                        <option value="7.75"></option>
                        <option value="8">8</option>
                        <option value="8.25"></option>
                        <option value="8.5"></option>
                        <option value="8.75"></option>
                        <option value="9">9</option>
                        <option value="9.25"></option>
                        <option value="9.5"></option>
                        <option value="9.75"></option>
                        <option value="10">10</option>
                    </datalist>
                </div>
                <div style="grid-column:2; grid-row:3;padding:0 2px;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Flavour</p>
                    <div class="v-small range-val" id="flavourVal">
                        <?= old("flavour", $production->flavour) ?>
                    </div>
                    <input type="range" min="6" max="10" name="flavour" id="flavour" list="range-6-10" step="0.25" value="<?= old("flavour", $production->flavour) ?>" onchange="showRangeValue('flavour', 'flavourVal');">
                    <datalist id="range-6-10" class="range-6-10">
                        <option value="6">6</option>
                        <option value="6.25"></option>
                        <option value="6.5"></option>
                        <option value="6.75"></option>
                        <option value="7">7</option>
                        <option value="7.25"></option>
                        <option value="7.5"></option>
                        <option value="7.75"></option>
                        <option value="8">8</option>
                        <option value="8.25"></option>
                        <option value="8.5"></option>
                        <option value="8.75"></option>
                        <option value="9">9</option>
                        <option value="9.25"></option>
                        <option value="9.5"></option>
                        <option value="9.75"></option>
                        <option value="10">10</option>
                    </datalist>
                </div>
                <div style="grid-column:3; grid-row:3;padding:0 2px;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Aftertaste</p>
                    <div class="v-small range-val" id="aftertasteVal">
                        <?= old("aftertaste", $production->aftertaste) ?>
                    </div>
                    <input type="range" min="6" max="10" name="aftertaste" id="aftertaste" list="range-6-10" step="0.25" value="<?= old("aftertaste", $production->aftertaste) ?>" onchange="showRangeValue('aftertaste', 'aftertasteVal');">
                    <datalist id="range-6-10" class="range-6-10">
                        <option value="6">6</option>
                        <option value="6.25"></option>
                        <option value="6.5"></option>
                        <option value="6.75"></option>
                        <option value="7">7</option>
                        <option value="7.25"></option>
                        <option value="7.5"></option>
                        <option value="7.75"></option>
                        <option value="8">8</option>
                        <option value="8.25"></option>
                        <option value="8.5"></option>
                        <option value="8.75"></option>
                        <option value="9">9</option>
                        <option value="9.25"></option>
                        <option value="9.5"></option>
                        <option value="9.75"></option>
                        <option value="10">10</option>
                    </datalist>
                </div>
                <div style="grid-column:4; grid-row:3;padding:0 2px;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Acidity <span class="v-small"> (Intensity)</span></p>
                    <div class="v-small range-val" id="acidityVal">
                        <?= old("acidity", $production->acidity) ?>
                    </div>
                    <input type="range" min="0" max="4" name="acidity" id="acidity" list="acidity_list" step="1" value="<?= old("acidity", $production->acidity) ?>" onchange="showRangeValue('acidity', 'acidityVal');">
                    <datalist id="acidity_list" class="acidity-list">
                        <option value="0">High</option>
                        <option value="1"></option>
                        <option value="2">|</option>
                        <option value="3"></option>
                        <option value="4">Low</option>
                    </datalist>
                </div>
                <div style="grid-column:5; grid-row:3;padding:0 2px;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Body <span class="v-small"> (Level)</span></p>
                    <div class="v-small range-val" id="bodyVal">
                        <?= old("body", $production->body) ?>
                    </div>
                    <input type="range" min="0" max="4" name="body" id="body" list="body-list" step="1" value="<?= old("body", $production->body) ?>" onchange="showRangeValue('body', 'bodyVal');">
                    <datalist id="body-list" class="body-list">
                        <option value="0">Heavy</option>
                        <option value="1"></option>
                        <option value="2">|</option>
                        <option value="3"></option>
                        <option value="4">Thin</option>
                    </datalist>
                </div>
                <div style="grid-column:6; grid-row:3;padding:0 1px;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Clean Cup <span class="v-small"> (Level)</span></p>
                    <div class="v-small range-val" id="clean_cupVal">
                        <?= old("clean_cup", $production->clean_cup) ?>
                    </div>
                    <input type="range" min="0" max="4" name="clean_cup" id="clean_cup" list="clean-cup-list" step="1" value="<?= old("clean_cup", $production->clean_cup) ?>" onchange="showRangeValue('clean_cup', 'clean_cupVal');">
                    <datalist id="clean-cup-list" class="clean-cup-list">
                        <option value="0">Tainted</option>
                        <option value="1"></option>
                        <option value="2">|</option>
                        <option value="3"></option>
                        <option value="4">Clean</option>
                    </datalist>
                </div>
                <div style="grid-column:7; grid-row:3;padding:0 2px;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 4pt;text-indent: 0pt;text-align: left;">Sweetness <span class="v-small"> (Level)</span></p>
                    <div class="v-small range-val" id="sweetnessVal">
                        <?= old("sweetness", $production->sweetness) ?>
                    </div>
                    <input type="range" min="0" max="4" name="sweetness" id="sweetness" list="sweetness-list" step="1" value="<?= old("sweetness", $production->sweetness) ?>" onchange="showRangeValue('sweetness', 'sweetnessVal');">
                    <datalist id="sweetness-list" class="sweetness-list">
                        <option value="0">Sour</option>
                        <option value="1"></option>
                        <option value="2">|</option>
                        <option value="3"></option>
                        <option value="4">Sweet</option>
                    </datalist>
                </div>
            </div>

            <p class="s4" style="padding-left: 34pt;text-indent: -23pt;text-align: left;">5. Packaging &amp; Grinding QC</p>
            <div class="packaging">
                <div style="grid-column: 1; grid-row:1;">
                    <p class="v-small">(Random check on 1 in every 100 bags)</p>
                </div>
                <div style="grid-column:3; grid-row:1;">
                    <div class="s9" style="display: grid; grid-template-columns:repeat(2,auto);text-align:center;">
                        <div>Pass</div>
                        <div>Fail</div>
                    </div>
                </div>
                <div style="grid-column:4; grid-row:1;">
                    <div class="s9" style="display: grid; grid-template-columns:repeat(2,auto);text-align:center;">
                        <div>Pass</div>
                        <div>Fail</div>
                    </div>
                </div>
                <div style="grid-column:5; grid-row:1;">
                    <div class="s9" style="display: grid; grid-template-columns:repeat(2,auto);text-align:center;">
                        <div>Pass</div>
                        <div>Fail</div>
                    </div>
                </div>
                <div style="grid-column:6; grid-row:1;">
                    <div class="s9" style="display: grid; grid-template-columns:repeat(2,auto);text-align:center;">
                        <div>Pass</div>
                        <div>Fail</div>
                    </div>
                </div>

                <div style="grid-column: 1 / SPAN 2; grid-row:2;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 13pt;text-indent: 0pt;text-align: left;">Packaging Integrity Check (Seals, Labels, Expiry Date)</p>
                </div>
                <div style="grid-column: 3; grid-row:2;">
                    <div style="display: grid; grid-template-columns:repeat(2,auto);">
                        <input id="quality_check_1" name="quality_check_1" type="radio" style="vertical-align: middle;" <?= $production->quality_check_1 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('quality_check_1', 1) ?> />
                        <input id="quality_check_1" name="quality_check_1" type="radio" style="vertical-align: middle;" <?= $production->quality_check_1 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('quality_check_1', 0) ?> />
                    </div>
                </div>

                <div style="grid-column: 4; grid-row:2;">
                    <div style="display: grid; grid-template-columns:repeat(2,auto);">
                        <input id="quality_check_2" name="quality_check_2" type="radio" style="vertical-align: middle;" <?= $production->quality_check_2 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('quality_check_2', 1) ?> />
                        <input id="quality_check_2" name="quality_check_2" type="radio" style="vertical-align: middle;" <?= $production->quality_check_2 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('quality_check_2', 0) ?> />
                    </div>
                </div>

                <div style="grid-column: 5; grid-row:2;">
                    <div style="display: grid; grid-template-columns:repeat(2,auto);">
                        <input id="quality_check_3" type="radio" name="quality_check_3" style="vertical-align: middle;" <?= $production->quality_check_3 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('quality_check_3', 1) ?>>
                        <input id="quality_check_3" type="radio" name="quality_check_3" style="vertical-align: middle;" <?= $production->quality_check_3 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('quality_check_3', 0) ?>>
                    </div>
                </div>

                <div style="grid-column: 6; grid-row:2;">
                    <div style="display: grid; grid-template-columns:repeat(2,auto);">
                        <input id="quality_check_4" type="radio" name="quality_check_4" style="vertical-align: middle;" <?= $production->quality_check_4 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('quality_check_4', 1) ?>>
                        <input id="quality_check_4" type="radio" name="quality_check_4" style="vertical-align: middle;" <?= $production->quality_check_4 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('quality_check_4', 0) ?>>
                    </div>
                </div>

                <div style="grid-column:1; grid-row:3;">
                    <p class="s3" style="padding-left: 14pt;text-indent: 0pt;text-align: left;margin-top:15px;">Weight Accuracy (Bag weight +/- 0.03% / kg)</p>
                </div>
                <div style="grid-column:3; grid-row:3;">
                    <input class="grid-cell s3" type="number" name="weight_accuracy_1" id="weight_accuracy_1" step="0.01" placeholder="0.00" value="<?= number_format(old("weight_accuracy_1", esc($production->weight_accuracy_1)), 2) ?>">
                </div>
                <div style="grid-column:4; grid-row:3;">
                    <input class="grid-cell s3" type="number" name="weight_accuracy_2" id="weight_accuracy_2" step="0.01" placeholder="0.00" value="<?= number_format(old("weight_accuracy_2", esc($production->weight_accuracy_2)), 2) ?>">
                </div>
                <div style="grid-column:5; grid-row:3;">
                    <input class="grid-cell s3" type="number" name="weight_accuracy_3" id="weight_accuracy_3" step="0.01" placeholder="0.00" value="<?= number_format(old("weight_accuracy_3", esc($production->weight_accuracy_3)), 2) ?>">
                </div>
                <div style="grid-column:6; grid-row:3;">
                    <input class="grid-cell s3" type="number" name="weight_accuracy_4" id="weight_accuracy_4" step="0.01" placeholder="0.00" value="<?= number_format(old("weight_accuracy_4", esc($production->weight_accuracy_4)), 2) ?>">
                </div>

                <div style="grid-column: 1; grid-row:4;">
                    <p class="s3" style="padding-left: 24pt;text-indent: 0pt;text-align: left;margin-top:15px;">Grind Size Consistency (If applicable)</p>
                </div>

                <div style="grid-column: 2; grid-row:4;">
                    <div style="display: grid; grid-template-columns:repeat(2,auto);">
                        <label class="s3" for="grind_size_espresso">Espresso</label>
                        <label class="s3" for="grind_size_filter">Filter</label>

                        <input id="grind_size_espresso" type="radio" name="grind_size" style="vertical-align: middle;" <?= $production->grind_size == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('grind_size', 1) ?>>
                        <input id="grind_size_filter" type="radio" name="grind_size" style="vertical-align: middle;" <?= $production->grind_size == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('grind_size', 0) ?>>
                    </div>
                </div>

                <div style="grid-column:4; grid-row:4;">
                    <p class="s3 grid-cell" for="packaging_qc_by">Packaging QC By:</p>
                </div>
                <div style="grid-column:5 / SPAN 6; grid-row:4;">
                    <input class="grid-cell" style="padding:0; margin:0;height:100%;" type="text" name="packaging_qc_by" id="packaging_qc_by" value="<?= old("packaging_qc_by", esc($production->packaging_qc_by)) ?>">
                    </p>
                </div>

            </div>

            <p class="s4" style="padding-top: 9pt;padding-bottom: 2pt;padding-left: 36pt;text-indent: -22pt;text-align: left;">6. Final Approval &amp; Actions Taken</p>
            <div class="final-approval">
                <!-- 5 columns -->
                <div style="grid-column:1; grid-row:1;">
                    <p class="s3">Batch Approved for Packaging? <span>
                </div>
                <div style="grid-column: 2; grid-row:1;">
                    <div style="display: grid;grid-template-columns:repeat(2,auto);">
                        <label class="s3 grid-cell-center" for="batch_approved_yes">Yes</label>
                        <label class="s3 grid-cell-center" for="batch_approved_no">No</label>
                        <input type="radio" name="batch_approved" id="batch_approved" class="s9" style="vertical-align: middle;" <?= $production->batch_approved == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('batch_approved', 1) ?>>
                        <input type="radio" name="batch_approved" id="batch_approved" class="s9" style="vertical-align: middle;" <?= $production->batch_approved == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('batch_approved', 0) ?>>
                    </div>
                </div>
                <div style="grid-column: 4; grid-row: 1;">
                    <p class="s15">Final QC Approval by:</p>
                </div>
                <div style="grid-column: 5; grid-row: 1;">
                    <a id="btnfinalqcapproval" class="button v-small" style="width:-webkit-fill-available; color:white;" href="#" onclick="finalqcapproval();">Click to Approve</a>

                    <div style="display:grid; gap:0; grid-template-columns: 80% 20%;">
                        <input type="hidden" name="final_qc_approval" id="final_qc_approval" style="width:-webkit-fill-available;" value="<?= old("final_qc_approval", esc($production->final_qc_approval)) ?>" disabled>
                        <a id="cancelfinalqcapproval" href="#" onclick="cancelqcapproval();" style="align-content:center; justify-self:center; text-align:center; width:30px; border-style: solid; border-radius:10px; background-color:dimgrey; color:white;" hidden >x</a>
                    </div>
                </div>

                <div style="grid-column: 1 / SPAN 3; grid-row: 2;">
                    <p class="s3">If No, Action Taken:</p>
                    <div style="display: grid;grid-template-columns:repeat(3,auto);">
                        <label class="s3" for="action_taken_adjust">Adjust Profile &amp; Re-roast</label>
                        <label class="s3" for="action_taken_blend">Blend with Another Batch</label>
                        <label class="s3" for="action-taken-reject">Reject &amp; Report</label>
                        <input type="checkbox" name="action_taken_adjust[]" id="action_taken_adjust" value="1" <?= $production->action_taken_adjust ? 'checked' : '' ?>>
                        <input type="checkbox" name="action_taken_blend[]" id="action_taken_blend" value="1" <?= $production->action_taken_blend  ? 'checked' : '' ?>>
                        <input type="checkbox" name="action_taken_reject[]" id="action_taken_reject" value="1" <?= $production->action_taken_reject ? 'checked' : '' ?>>
                    </div>
                </div>

                <div style="grid-column:4; grid-row:2;">
                    <p class="s15 grid-cell-center">Time Completed:</p>
                </div>
                <div style="grid-column:5; grid-row:2;">
                    <input class="grid-cell" type="time" name="time_completed" id="time_completed" value="<?= old("time_completed", esc($production->time_completed)) ?>">
                </div>

            </div>
            <button class="button grid-cell" type="submit">Save</button>
            <a href="<?= url_to('Production::index') ?>" class="button grid-cell" style="background-color: darkred;">Cancel</a>
        </div>
    </div>
</main>

<script type='text/javascript'>

    function cancelqcapproval()
    {
        $('#final_qc_approval').val('');
        $("#final_qc_approval").prop("type", "hidden");
        $('#final_qc_approval').hide();
        $('#cancelfinalqcapproval').hide();
        $('#btnfinalqcapproval').show();
    }

    function finalqcapproval()
    {
        DayPilot.Modal.confirm("Do you Approve the final quality check?",
            { theme: "modal_rounded" }).then(function(args) {
                if(args.result){
                    $("#final_qc_approval").prop("type", "text");
                    $('#final_qc_approval').val('<?= esc($production->checked_by) ?>');
                    $('#btnfinalqcapproval').hide();
                    $('#final_qc_approval').show();
                    $('#cancelfinalqcapproval').show();
                }
            }
        );
    }


    function showRangeValue(rangeId, markerId) {
        var val = document.getElementById(rangeId).value;
        document.getElementById(markerId).innerHTML = val;
    }

    function getGreenCoffees(id) {
        var coffeename = document.getElementById(id).value;
        var productionid = "<?= isset($production->ProductionID) ? $production->ProductionID : 0  ?>";
        if (productionid > 0) {
            return;
        }
        //alert(productionid);
        //var csrfvalue = "<?= csrf_hash() ?>";

        var url = "<?= base_url('production/getgreencoffees/') ?>";
        url = url + encodeURI(coffeename);
        //       console.log(url);
        //alert(coffeename);
        htmx.ajax('GET',
            url, {
                target: "#res",
                swap: 'none',
                handler: (_, response) => {
                    var restext = response.xhr.responseText;
                    var data = JSON.parse(restext);
                    //console.log(data);
                    var sel = data['selects'];

                    // var cer = data['certchecks'];

                    // //console.log(cer);
                    // for (const key in cer) {
                    //     //    ele = cer[key];
                    //     console.log(key);
                    //     console.log(cer[key]);
                    //     $('#' + key).replaceWith(cer[key]);
                    // }

                    var certs = data['certifications'];
                    //console.log(certs);
                    $('#certifications').replaceWith(certs.certcheckbox);
                    //$('#cert-header').replaceWith(certs.certheader);

                    var obj;
                    var j = 1;
                    for (const key in sel) {
                        str = sel[key];
                        for (const k in str) {
                            //                          console.log(str[k]);
                            $('#' + k).replaceWith(str[k]);
                        }
                    }
                },
            }
        );

        $().ready(()=>{
// On Page Ready
        });
    }
</script>